"use client"

// Authentication utilities using localStorage (mock)
// Replace with real JWT/session when connecting to MySQL

export interface User {
  id: string
  email: string
  fullName: string
  phone: string
  role: "victim" | "admin"
}

const AUTH_KEY = "flood_rescue_auth"
const USER_KEY = "flood_rescue_user"

export function isAuthenticated(): boolean {
  if (typeof window === "undefined") return false
  return localStorage.getItem(AUTH_KEY) === "true"
}

export function getCurrentUser(): User | null {
  if (typeof window === "undefined") return null
  const userJson = localStorage.getItem(USER_KEY)
  return userJson ? JSON.parse(userJson) : null
}

export function login(email: string, password: string): { success: boolean; user?: User; error?: string } {
  // Mock authentication - replace with real API call
  const mockUsers: Record<string, { password: string; user: User }> = {
    "admin@rescue.vn": {
      password: "admin123",
      user: {
        id: "admin-001",
        email: "admin@rescue.vn",
        fullName: "Quản trị viên",
        phone: "0900000000",
        role: "admin",
      },
    },
    "user@test.com": {
      password: "user123",
      user: {
        id: "user-001",
        email: "user@test.com",
        fullName: "Nguyễn Văn A",
        phone: "0912345678",
        role: "victim",
      },
    },
  }

  const account = mockUsers[email]
  if (!account || account.password !== password) {
    return { success: false, error: "Email hoặc mật khẩu không đúng" }
  }

  localStorage.setItem(AUTH_KEY, "true")
  localStorage.setItem(USER_KEY, JSON.stringify(account.user))
  return { success: true, user: account.user }
}

export function register(data: {
  email: string
  password: string
  fullName: string
  phone: string
}): { success: boolean; user?: User; error?: string } {
  // Mock registration - replace with real API call
  const existingUsers = JSON.parse(localStorage.getItem("registered_users") || "[]")

  if (existingUsers.find((u: User) => u.email === data.email)) {
    return { success: false, error: "Email đã được sử dụng" }
  }

  const newUser: User = {
    id: `user-${Date.now()}`,
    email: data.email,
    fullName: data.fullName,
    phone: data.phone,
    role: "victim",
  }

  existingUsers.push(newUser)
  localStorage.setItem("registered_users", JSON.stringify(existingUsers))
  localStorage.setItem(AUTH_KEY, "true")
  localStorage.setItem(USER_KEY, JSON.stringify(newUser))

  return { success: true, user: newUser }
}

export function logout() {
  localStorage.removeItem(AUTH_KEY)
  localStorage.removeItem(USER_KEY)
}

export function requireAuth(requiredRole?: "admin" | "victim"): User | null {
  const user = getCurrentUser()
  if (!user || !isAuthenticated()) {
    if (typeof window !== "undefined") {
      window.location.href = "/login"
    }
    return null
  }

  if (requiredRole && user.role !== requiredRole) {
    if (typeof window !== "undefined") {
      window.location.href = "/"
    }
    return null
  }

  return user
}
