"use client"

import { useEffect } from "react"
import { useRouter } from "next/navigation"
import { RescueRequestForm } from "@/components/rescue-request-form"
import { isAuthenticated } from "@/lib/auth"

export default function RequestPage() {
  const router = useRouter()

  useEffect(() => {
    if (!isAuthenticated()) {
      router.push("/login")
    }
  }, [router])

  return (
    <div className="min-h-screen bg-gradient-to-b from-blue-50 to-white">
      <div className="container mx-auto px-4 py-8">
        <RescueRequestForm />
      </div>
    </div>
  )
}
