import { RescueMap } from "@/components/rescue-map"
import Link from "next/link"
import { Button } from "@/components/ui/button"
import { ArrowLeft } from "lucide-react"
import { SiteHeader } from "@/components/site-header"

export default function MapPage() {
  return (
    <div className="min-h-screen bg-white">
      <SiteHeader />

      <div className="container mx-auto px-4 py-4">
        <div className="mb-4">
          <Link href="/">
            <Button variant="ghost" size="sm">
              <ArrowLeft className="w-4 h-4 mr-2" />
              Quay lại
            </Button>
          </Link>
        </div>
        <h1 className="text-2xl font-bold mb-4">Bản đồ cứu hộ trực tiếp</h1>
        <RescueMap />
      </div>
    </div>
  )
}
