# Hệ thống Cứu Hộ Lũ Lụt

Ứng dụng web hỗ trợ cứu hộ người bị nạn trong tình huống lũ lụt với định vị GPS và quản lý yêu cầu real-time.

## Tính năng chính

### Người dùng (Nạn nhân)
- Đăng ký/đăng nhập tài khoản
- Gửi yêu cầu cứu hộ với định vị GPS
- Upload ảnh hiện trường
- Theo dõi trạng thái yêu cầu
- Xem bản đồ các yêu cầu cứu hộ

### Quản trị viên
- Dashboard quản lý tất cả yêu cầu
- Phân công đội cứu hộ
- Cập nhật trạng thái yêu cầu
- Xem thống kê và báo cáo
- Filter theo mức độ ưu tiên/trạng thái

## Tech Stack

- **Frontend:** Next.js 15, React 19, TypeScript
- **UI:** Tailwind CSS v4, shadcn/ui
- **Database:** MySQL (sử dụng mysql2)
- **Authentication:** JWT với bcrypt
- **Maps:** Leaflet/Mapbox GL JS (tùy chọn)

## Cài đặt

### 1. Clone và cài dependencies

\`\`\`bash
git clone <repo-url>
cd flood-rescue
npm install
\`\`\`

### 2. Cấu hình database

Xem file [DATABASE_SETUP.md](./DATABASE_SETUP.md) để biết chi tiết cách cài đặt MySQL.

### 3. Thiết lập environment variables

Tạo file `.env.local`:

\`\`\`
DATABASE_URL=mysql://user:password@localhost:3306/flood_rescue
DB_HOST=localhost
DB_USER=root
DB_PASSWORD=your_password
DB_NAME=flood_rescue
JWT_SECRET=your-secret-key-here
\`\`\`

### 4. Chạy development server

\`\`\`bash
npm run dev
\`\`\`

Mở [http://localhost:3000](http://localhost:3000) để xem ứng dụng.

## Tài khoản demo

Hiện tại sử dụng localStorage để demo:

- **Admin:** admin@rescue.vn / admin123
- **User:** user@test.com / user123

Khi kết nối MySQL, authentication sẽ chuyển sang JWT thật.

## Cấu trúc thư mục

\`\`\`
├── app/
│   ├── page.tsx              # Trang chủ
│   ├── login/                # Đăng nhập
│   ├── register/             # Đăng ký
│   ├── request/              # Form yêu cầu cứu hộ
│   ├── admin/                # Dashboard admin
│   ├── map/                  # Bản đồ
│   └── api/                  # API routes (khi kết nối DB)
├── components/
│   ├── ui/                   # shadcn components
│   ├── site-header.tsx       # Header với auth
│   ├── rescue-request-form.tsx
│   ├── admin-dashboard.tsx
│   └── rescue-map.tsx
├── lib/
│   ├── auth.ts               # Authentication utilities
│   └── db.ts                 # Database connection (chưa dùng)
└── scripts/
    └── database-schema.sql   # MySQL schema
\`\`\`

## Deploy lên Vercel

1. Push code lên GitHub
2. Import project vào Vercel
3. Thêm environment variables vào Vercel dashboard
4. Deploy!

## Roadmap

- [ ] Kết nối MySQL thật thay vì localStorage
- [ ] JWT authentication với bcrypt
- [ ] Real-time updates với WebSocket/Pusher
- [ ] Tích hợp bản đồ Leaflet/Mapbox
- [ ] Upload ảnh lên cloud (AWS S3/Cloudinary)
- [ ] Push notifications cho mobile
- [ ] Export báo cáo Excel/PDF
- [ ] Multi-language support

## Đóng góp

Mọi đóng góp đều được chào đón! Vui lòng tạo Pull Request.

## License

MIT
