"use client"

import Link from "next/link"
import { Button } from "@/components/ui/button"
import { Waves, LogOut } from "lucide-react"
import { useEffect, useState } from "react"
import { getCurrentUser, logout, type User } from "@/lib/auth"
import { useRouter } from "next/navigation"

export function SiteHeader() {
  const [user, setUser] = useState<User | null>(null)
  const router = useRouter()

  useEffect(() => {
    setUser(getCurrentUser())
  }, [])

  const handleLogout = () => {
    logout()
    setUser(null)
    router.push("/")
    router.refresh()
  }

  return (
    <header className="border-b bg-white/80 backdrop-blur-sm sticky top-0 z-50">
      <div className="container mx-auto px-4 py-4 flex items-center justify-between">
        <Link href="/" className="flex items-center gap-2">
          <div className="w-10 h-10 bg-blue-600 rounded-full flex items-center justify-center">
            <Waves className="w-6 h-6 text-white" />
          </div>
          <div>
            <h1 className="font-bold text-xl text-balance">Cứu Hộ Lũ Lụt</h1>
            <p className="text-xs text-muted-foreground">Hỗ trợ khẩn cấp 24/7</p>
          </div>
        </Link>
        <nav className="flex items-center gap-3">
          {user ? (
            <>
              <span className="text-sm font-medium text-blue-700 hidden sm:inline">Xin chào, {user.fullName}</span>
              <Link href="/request">
                <Button size="sm" className="bg-blue-600 hover:bg-blue-700">
                  Gọi cứu hộ
                </Button>
              </Link>
              {user.role === "admin" && (
                <Link href="/admin">
                  <Button size="sm" variant="outline">
                    Quản trị
                  </Button>
                </Link>
              )}
              <Button size="sm" variant="ghost" onClick={handleLogout}>
                <LogOut className="w-4 h-4 sm:mr-2" />
                <span className="hidden sm:inline">Đăng xuất</span>
              </Button>
            </>
          ) : (
            <>
              <Link href="/login">
                <Button size="sm" variant="outline">
                  Đăng nhập
                </Button>
              </Link>
              <Link href="/request">
                <Button size="sm" className="bg-blue-600 hover:bg-blue-700">
                  Gọi cứu hộ
                </Button>
              </Link>
            </>
          )}
        </nav>
      </div>
    </header>
  )
}
