"use client"

import { useSearchParams } from "next/navigation"
import Link from "next/link"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { CheckCircle, MapPin, Phone } from "lucide-react"

export default function SuccessPage() {
  const searchParams = useSearchParams()
  const requestId = searchParams.get("id")

  return (
    <div className="min-h-screen bg-gradient-to-b from-green-50 to-white flex items-center justify-center p-4">
      <Card className="max-w-lg w-full">
        <CardHeader className="text-center">
          <div className="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <CheckCircle className="w-8 h-8 text-green-600" />
          </div>
          <CardTitle className="text-2xl text-green-600">Yêu cầu đã được gửi!</CardTitle>
          <CardDescription>Đội cứu hộ sẽ liên hệ với bạn trong vòng 5-10 phút</CardDescription>
        </CardHeader>
        <CardContent className="space-y-6">
          {requestId && (
            <div className="bg-gray-50 rounded-lg p-4 text-center">
              <p className="text-sm text-muted-foreground mb-1">Mã yêu cầu của bạn</p>
              <p className="text-xl font-bold text-red-600">{requestId.toUpperCase()}</p>
            </div>
          )}

          <div className="space-y-3">
            <div className="flex items-start gap-3 text-sm">
              <Phone className="w-5 h-5 text-red-600 mt-0.5" />
              <div>
                <p className="font-medium">Giữ máy bật</p>
                <p className="text-muted-foreground">Đội cứu hộ sẽ gọi cho bạn để xác nhận vị trí và tình huống</p>
              </div>
            </div>
            <div className="flex items-start gap-3 text-sm">
              <MapPin className="w-5 h-5 text-red-600 mt-0.5" />
              <div>
                <p className="font-medium">Ở nguyên vị trí</p>
                <p className="text-muted-foreground">Vui lòng ở lại vị trí đã báo để đội cứu hộ dễ tìm thấy bạn</p>
              </div>
            </div>
          </div>

          <div className="flex flex-col gap-2 pt-4">
            <Link href="/map" className="w-full">
              <Button variant="outline" className="w-full bg-transparent">
                <MapPin className="w-4 h-4 mr-2" />
                Theo dõi trên bản đồ
              </Button>
            </Link>
            <Link href="/" className="w-full">
              <Button variant="ghost" className="w-full">
                Về trang chủ
              </Button>
            </Link>
          </div>
        </CardContent>
      </Card>
    </div>
  )
}
