import Link from "next/link"
import { Button } from "@/components/ui/button"
import { Phone, Users, Clock, Waves } from "lucide-react"
import { SiteHeader } from "@/components/site-header"

export default function HomePage() {
  return (
    <div className="min-h-screen bg-gradient-to-b from-blue-50 to-white">
      <SiteHeader />

      {/* Hero Section */}
      <section className="container mx-auto px-4 py-16 md:py-24">
        <div className="max-w-4xl mx-auto text-center space-y-6">
          <h2 className="text-4xl md:text-6xl font-bold text-balance">
            Cứu Hộ Lũ Lụt
            <br />
            <span className="text-blue-600">Nhanh Chóng & An Toàn</span>
          </h2>
          <p className="text-lg md:text-xl text-muted-foreground text-pretty max-w-2xl mx-auto">
            Hệ thống cứu hộ người bị nạn do lũ lụt với định vị GPS chính xác, kết nối trực tiếp với đội cứu hộ gần nhất.
            Báo cáo tình trạng ngập nước và nhận hỗ trợ kịp thời.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center pt-4">
            <Link href="/request">
              <Button size="lg" className="bg-blue-600 hover:bg-blue-700 text-lg px-8">
                <Phone className="w-5 h-5 mr-2" />
                Yêu cầu cứu hộ ngay
              </Button>
            </Link>
            <Link href="/map">
              <Button size="lg" variant="outline" className="text-lg px-8 bg-transparent">
                <Waves className="w-5 h-5 mr-2" />
                Xem bản đồ
              </Button>
            </Link>
          </div>
        </div>
      </section>

      {/* Features */}
      <section className="container mx-auto px-4 py-16 bg-white">
        <div className="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto">
          <div className="text-center space-y-3">
            <div className="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto">
              <Clock className="w-8 h-8 text-blue-600" />
            </div>
            <h3 className="font-semibold text-xl">Phản Hồi Nhanh</h3>
            <p className="text-muted-foreground text-pretty">
              Đội cứu hộ có mặt trong vòng 30-60 phút sau khi nhận yêu cầu khẩn cấp
            </p>
          </div>
          <div className="text-center space-y-3">
            <div className="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto">
              <Waves className="w-8 h-8 text-blue-600" />
            </div>
            <h3 className="font-semibold text-xl">Theo Dõi Mực Nước</h3>
            <p className="text-muted-foreground text-pretty">
              Cập nhật mức độ ngập lụt và ưu tiên cứu hộ các trường hợp nguy hiểm
            </p>
          </div>
          <div className="text-center space-y-3">
            <div className="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto">
              <Users className="w-8 h-8 text-blue-600" />
            </div>
            <h3 className="font-semibold text-xl">Đội Chuyên Nghiệp</h3>
            <p className="text-muted-foreground text-pretty">
              Đội ngũ cứu hộ được đào tạo bài bản, trang bị thuyền và dụng cụ cứu hộ chuyên dụng
            </p>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="container mx-auto px-4 py-16">
        <div className="max-w-3xl mx-auto bg-blue-600 rounded-2xl p-8 md:p-12 text-center text-white">
          <h3 className="text-3xl md:text-4xl font-bold mb-4 text-balance">Đang bị ngập lụt?</h3>
          <p className="text-lg mb-6 text-blue-50 text-pretty">Đừng lo lắng! Chúng tôi luôn sẵn sàng cứu hộ bạn 24/7</p>
          <Link href="/request">
            <Button size="lg" variant="secondary" className="text-lg px-8">
              Gọi cứu hộ ngay
            </Button>
          </Link>
        </div>
      </section>

      {/* Footer */}
      <footer className="border-t bg-gray-50 py-8">
        <div className="container mx-auto px-4 text-center text-sm text-muted-foreground">
          <p>© 2025 Cứu Hộ Lũ Lụt. Hỗ trợ khẩn cấp 24/7</p>
          <p className="mt-2">Hotline: 1900-1234-56</p>
        </div>
      </footer>
    </div>
  )
}
