"use client"

import { useEffect } from "react"
import { useRouter } from "next/navigation"
import { AdminDashboard } from "@/components/admin-dashboard"
import { requireAuth } from "@/lib/auth"

export default function AdminPage() {
  const router = useRouter()

  useEffect(() => {
    const user = requireAuth("admin")
    if (!user) {
      router.push("/login")
    }
  }, [router])

  return <AdminDashboard />
}
